/*
Fixierung der Header-Divisions nach Harry Kämpf
http://www.kaempf-nk.de/webseitengestaltung/blog/header-scroll-und-fix.html
(getElementsByClassName("nav2") muß deswegen sein, weil es mit getElementByIdName("nav2") nicht funktioniert)
*/

/**
	* Ergänzung evtl. fehlender Html5-Unterstützung
	*
	* @param none
	* @return none
	*/
		(function(d){

			if(!d.createTextNode) return;

			var elem = "header|nav|section".split('|');
			for(var i=0; i<elem.length; i++){
				d.createElement(elem[i]);
			}
		}
	)(document);

/**
	* Fixierung der Header-Divisions
	*
	* @param none
	* @return none
	*/
	
	var startPos;

	if(typeof String.prototype.trim !== 'function') {
	  String.prototype.trim = function() {
		return this.replace(/^\s+|\s+$/g, ''); 
	  }
	}
	
	window.onload=function(){
		window.scrollTo(0,0);
		startPos = document.getElementsByClassName("nav2")[0].offsetTop;  /* GEÄNDERT*/
	};
	
	window.onscroll = function () {
		elem = document.getElementsByClassName("nav2")[0];   /* GEÄNDERT*/
		var myFixedClass='fixed-navi';

		var body=(document.compatMode && document.compatMode != "BackCompat")? document.documentElement : document.body;
		var topPos=document.all? body.scrollTop : pageYOffset;

		if (topPos > startPos) {
			if (elem.className.indexOf(myFixedClass)== -1) {
				if (elem.className != '') elem.className = elem.className + ' ' + myFixedClass;
				else elem.className = myFixedClass;
			}
		} else {
			var sRegEx = new RegExp(myFixedClass, "g");    
			elem.className = elem.className.replace(sRegEx,"").trim();
		}
	}
// -------------------------------------------------------------- 


function bestellung() {
a="mai"
b="lto:ch"
c="ristian"
d="@"
e="kanu-info-"
f="isar.de?&s"
g="ubject=Bestellung Kanukart"
h="en&body=(Bitte Name, Adresse und Tel.-Nr. angeben "
i="- Überweisung erst nach Erhalt der Dateien)"
adr=a+b+c+d+e+f+g+h+i
location.href =adr;
}




function allschl() {
  if (document.getElementById("aktuelles")) {document.getElementById("aktuelles").style.display="none";}
  if (document.getElementById("kurzinfo")) {document.getElementById("kurzinfo").style.display="none";}
  if (document.getElementById("verschiedenes1")) {document.getElementById("verschiedenes1").style.display="none";} 
  if (document.getElementById("verschiedenes2")) {document.getElementById("verschiedenes2").style.display="none";} 
  if (document.getElementById("verschiedenes3")) {document.getElementById("verschiedenes3").style.display="none";} 
  if (document.getElementById("verschiedenes4")) {document.getElementById("verschiedenes4").style.display="none";} 
  if (document.getElementById("verschiedenes5")) {document.getElementById("verschiedenes5").style.display="none";} 
  if (document.getElementById("verschiedenes6")) {document.getElementById("verschiedenes6").style.display="none";} 
  if (document.getElementById("kartenv")) {document.getElementById("kartenv").style.display="none";} 
  if (document.getElementById("karten1")) {document.getElementById("karten1").style.display="none";} 
  if (document.getElementById("karten2")) {document.getElementById("karten2").style.display="none";} 
  if (document.getElementById("karten3")) {document.getElementById("karten3").style.display="none";} 
  if (document.getElementById("karten4")) {document.getElementById("karten4").style.display="none";} 
  if (document.getElementById("karten5")) {document.getElementById("karten5").style.display="none";} 
  if (document.getElementById("kartenv_zus")) {document.getElementById("kartenv_zus").style.display="none";} 
  if (document.getElementById("karten1_zus")) {document.getElementById("karten1_zus").style.display="none";} 
  if (document.getElementById("karten2_zus")) {document.getElementById("karten2_zus").style.display="none";} 
  if (document.getElementById("karten3_zus")) {document.getElementById("karten3_zus").style.display="none";} 
  if (document.getElementById("karten4_zus")) {document.getElementById("karten4_zus").style.display="none";} 
  if (document.getElementById("karten5_zus")) {document.getElementById("karten5_zus").style.display="none";}
  if (document.getElementById("pegelv"))  {document.getElementById("pegelv").style.display="none";} 
  if (document.getElementById("pegel"))   {document.getElementById("pegel").style.display="none";} 
  if (document.getElementById("bilderv")) {document.getElementById("bilderv").style.display="none";} 
  if (document.getElementById("bilder0")) {document.getElementById("bilder0").style.display="none";} 
  if (document.getElementById("bilder1")) {document.getElementById("bilder1").style.display="none";} 
  if (document.getElementById("bilder2")) {document.getElementById("bilder2").style.display="none";} 
  if (document.getElementById("bilder3")) {document.getElementById("bilder3").style.display="none";} 
  if (document.getElementById("bilder4")) {document.getElementById("bilder4").style.display="none";} 
  if (document.getElementById("bilder5")) {document.getElementById("bilder5").style.display="none";}
}



// für Übergang von einer Bilderserie zu einem normalen Bild
function zu1()  {zu_vis('bi-serie11'); zu_vis('bi-serie12'); zu_vis('bi-serie13'); zu_vis('bi-serie14'); zu_vis('bi-serie15'); zu_vis('bi-serie16'); zu_vis('bi-serie17'); }
function zu2()  {zu_vis('bi-serie21'); zu_vis('bi-serie22'); zu_vis('bi-serie23'); zu_vis('bi-serie24'); zu_vis('bi-serie25'); zu_vis('bi-serie26'); zu_vis('bi-serie27'); }
function zu3()  {zu_vis('bi-serie31'); zu_vis('bi-serie32'); zu_vis('bi-serie33'); zu_vis('bi-serie34'); zu_vis('bi-serie35'); zu_vis('bi-serie36'); zu_vis('bi-serie37'); }
function zu4()  {zu_vis('bi-serie41'); zu_vis('bi-serie42'); zu_vis('bi-serie43'); zu_vis('bi-serie44'); zu_vis('bi-serie45'); zu_vis('bi-serie46'); zu_vis('bi-serie47'); }
function zu5()  {zu_vis('bi-serie51'); zu_vis('bi-serie52'); zu_vis('bi-serie53'); zu_vis('bi-serie54'); zu_vis('bi-serie55'); zu_vis('bi-serie56'); zu_vis('bi-serie57'); }




// per onload: Öffnen eines normalerweise verborgenen Kapitels schon beim Aufruf, z.B. per <a href="isar.htm?akt">
// funktioniert nicht, weil dadurch die Fixierung der Header-Divisions blockiert wird 
//function auf_kap() {
//	var kap = location.href.substring(location.href.length - 3);
//	if (kap == "akt") {
//		document.getElementById('aktuelles').style.display="block";
//		window.location="#aktuelles";
//		window.scrollBy(0, -45);
//	}else if (kap == "peg") {
//		document.getElementById('pegelv').style.display="block";
//		document.getElementById('hwms1').style.display="none";
//		document.getElementById('hwms2').style.display="block";
//		window.location="#hwms2";
//		window.scrollBy(0, -45);
//	}else {
//	}
//}


// auf('____')  / zu('____')  ohne #   display=block / display=none
function auf(id) {
   document.getElementById(id).style.display="block"; 
   }
function zu(id)  {
   document.getElementById(id).style.display="none"; 
   }
   



// auf-zu von "visibility=visible/hidden" (ohne #)
// Für die Bilderserien. Warum geht das nicht mit "display", also mit function auf() ?
function auf_vis(id) {document.getElementById(id).style.visibility="visible"; }
function zu_vis(id)  {document.getElementById(id).style.visibility="hidden"; }




// Öffnet bzw. schließt die mitgegebene id (ohne #) 
// und positioniert diese bzw. den folgenden Inhalt unter die (gelbe) Menüzeile
function auf_jp(id)  {
	document.getElementById(id).style.display="block";
	window.location="#"+id;
	window.location="#"+id;
   // # wird automatsch vorangestellt
   // ??? window.location 2x, weil es manchmal nur beim zweiten Aufruf reagiert
	window.scrollBy(0, -45);
}




function zu_jp(id)  {
	window.location="#"+id;
	window.location="#"+id;
      // # wird automatsch vorangestellt
	// ??? window.location 2x, weil es manchmal nur beim zweiten Aufruf reagiert
   window.scrollBy(0, -45);
	document.getElementById(id).style.display="none";
}




// Positioniert die mitgegebene id (ohne #) unter die (gelbe) Menüzeile
// ! denselben Effekt hat "auf_jp()"
function jump(id) {
window.location=id;
window.location=id;
window.scrollBy(0, -45);
}




// Für Kapitel Bilder
function bildwechsel(serie, bildname) { 
document.getElementById(serie).src="bilder/"+bildname; 
}




// Wechselt zwei HTML-Elemente mit id="xxx1" und id="xxx2" gegeneinander aus
// und springt ggf. zu einem angegebenen Ziel
function wechsel(node,jump){
// 1. Parameter steuert den Wechsel:
//    - wechsel(this) erkennt die id des AUFRUFENDEN Elements (mit ...1 oder ...2) und wechselt zum "Gegen-Element"
//    - wechsel('xxxx1') bzw. wechsel('xxxx2') wechselt innerhalb des im Parameter GENANNTEN Elemente-Paares
//    - wechsel() ohne Parameter veranlaßt keinen Wechsel
//    - wechsel('' , 'xxxx') veranlaßt keinen Wechsel, nur den geforderten Sprung
// 2. Parameter steuert Sprungziel:
//    - wechsel('...') ohne zweiten Parameter, nur Wechsel, kein Sprung
//    - wechsel('...','') mit leerem zweiten Parameter, nur Wechsel, kein Sprung
//    - wechsel('...','a') = Sprung * zum Anfang des eigenen Elementes (* Beginn unter der Kopfzeile von KII)
//   -  wechsel('...','xxxx1|xxxx2') = Sprung * zu Internziel (nur id, # wird automatisch vorangestellt) (* w.o.)
//
   // Parameter node auswerten für Wechsel, entweder id mit 1|2 oder node des aufrufenden Elements per (this)
   if(node.id == undefined) {
      //Aufruf war mit wechsel('xxxxxx1') oder wechsel('xxxxxx2')
      name = node.slice(0,node.length-1);                       // z.B. xxxxxx1 >> xxxxxx  = name
      sel  = node.slice(node.length-1,node.length-0);           // z.B. xxxxxx1 >>       1 = sel
      //alert (name+sel)
 }else{
      //Aufruf war mit wechsel(this)
      name = node.id.slice(0,node.id.length-1);                 // z.B. xxxxxx1 >> xxxxxx  = name
      sel  = node.id.slice(node.id.length-1,node.id.length-0);  // z.B. xxxxxx1 >>       1 = sel
      //alert (name+sel)
  }
   //Element wechseln
   if(sel == "1") {          // id=1 >> Wechsel auf Eintrag id=2
      document.getElementById(name + "1").style.display="none";
      document.getElementById(name + "2").style.display="block";
   }else if(sel == "2") {    // id=2 > Wechsel auf Eintrag id=1
      document.getElementById(name + "1").style.display="block";
      document.getElementById(name + "2").style.display="none";
   }else{
      alert ("Selector nicht 1 oder 2, kein Wechsel, nur Sprung");
   }
   // Parameter jump auswerten für Sprung
   if(jump == "") {                           // kein Sprung
      return;
   }else if(jump == "a") {                    // Sprung zum Elementanfang
      if(sel == 1) {
         window.location=("#" + name + "2");  // Scrollen zum Elementanfang 
      }else if(sel == 2){
         window.location=("#" + name + "1");  // Scrollen zum Elementanfang 
      }
      window.scrollBy(0, -40);	             // Zurück-Scrollen unter die Kopfzeile
   }else{                                     // Sprung zu Internziel
      window.location = "#" + jump;           // # wird hinzugefügt
      window.scrollBy(0, -40);                // Zurück-Scrollen unter die Kopfzeile
   }  
}




// Leporello, Aufruf aus z.B. id="xxxx941" heraus mit onclick="lepo(this);"
function lepo(node,jump) { 
   name = node.id.slice(0,node.id.length-3);                 // z.B. xxxxx941 >> xxxxxx    = var name   ... der id
   max  = node.id.slice(node.id.length-3,node.id.length-2);  // z.B. xxxxx941 >>       9   = var max    ... Gesamt-Zahl der Einträge
   nr   = node.id.slice(node.id.length-2,node.id.length-1);  // z.B. xxxxx941 >>        4  = var nr     ... des Eintrages
   sel  = node.id.slice(node.id.length-1,node.id.length-0);  // z.B. xxxxx941 >>         1 = var sel    ... Selector 1 oder 2
   // name = id ohne dreistellige Steuerzahl
   // max  = Zahl der Einträge 1-9
   // nr   = Nummer des einzelnen Eintrages 1-9
   // sel  = Selector 1 geschlossen / 2 geöffnet
   // jump ohne Eintrag ist Standard ohne Sprung
   // jump = "a" bei öffnen:    Sprung zum aufgerufenen Eintrag
   // jump = "a" bei schließen: Sprung zur Gesamt-Überschrift
   if(sel == '1') {
   // Selector 1 = geschlossener Eintrag
      for (var i = 1; i <= max; i++) { 
         document.getElementById(name + max + i + 1).style.display="block";
         document.getElementById(name + max + i + 2).style.display="none";
      }
      document.getElementById(name + max + nr + 1).style.display="none";
      document.getElementById(name + max + nr + 2).style.display="block";
      if(jump == "a") {
         window.location=("#" + name + max + nr + "2"); // Sprung zum Elementanfang von "2"
         window.location=("#" + name + max + nr + "2");
         //window.scrollBy(0, -45);	                    // Zurück-Scrollen unter die Kopfzeile bei kanu-info-isar.de			
      }else{
      return;
      }
   }else if(sel == '2') {
   // Selector 2 = geöffneter Eintrag
      document.getElementById(name + max + nr + 1).style.display="block";
      document.getElementById(name + max + nr + 2).style.display="none";
      if(jump == ""){
         return;
      }else if(jump == "a") {
         window.location=("#" + name); // Sprung zum Leporello-Anfang
         window.location=("#" + name);
         //window.scrollBy(0, -45);  // Zurück-Scrollen unter die Kopfzeile bei kanu-info-isar.de
      }else{
         window.location=("#" + jump); // Sprung zum angegebenen internen Ziel
      };
   }else{
      alert ("Selector nicht 1 oder 2");
   }             
}

